with calday as (
    select generate_series('2021-12-01', current_date, '1 day'::interval)::date as calday
)
, dh as (
    select dih.deal_id,dih.which_crm,
           min(dih.snapshot_date)snapshot_date,
           (dih.status='open' and dih_old.status='lost') as restart_deal
    from snb_b2b.niksm_b2b_deals_info_hist dih
      left join snb_b2b.niksm_b2b_deals_info_hist dih_old
        on dih.deal_id = dih_old.deal_id
        and dih.which_crm = dih_old.which_crm
        and dih.snapshot_date=dih_old.snapshot_date+1
     where dih.status='open'
       and dih_old.status='lost'
     group by  dih.deal_id,dih.which_crm,  (dih.status='open' and dih_old.status='lost')
)
, t_deal as (
    select di.deal_id,
           di.status = 'lost'                        as status_lost,
           di.status,
           di.lost_reason,
           di.contract_id,
           di.contract_type = 'Оферта'               as contract_offerta_flg,
           di.manager_group,
           di.manager_login,
           di.manager_name,
           di.channel,
           di.tags,
           di.potential,
           di.corp_client_id,
           to_timestamp(EXTRACT(EPOCH FROM  coalesce(di.add_time,dh.snapshot_date::timestamp))) at time zone 'UTC' as open_deal_time,
           coalesce(di.add_date, snapshot_date) as open_deal_date,
           di.pipeline_id = 5208781                      as phinics_flg,
           coalesce(dh.restart_deal,false) as  restart_deal
 from snb_b2b.niksm_b2b_deals_info di
left join dh
    on dh.deal_id = di.deal_id and dh.which_crm = di.which_crm
    where di.which_crm=6
)
, cw as (
    select cw.key                                                                                            as cw_ticket_key
         , cw.type
         , cw.status
         , cw.resolution
         , cw.resolution in ('fixed', 'targetLead') and cw.type = 'task'                                     as fixed_flg
         , (to_timestamp(EXTRACT(EPOCH FROM cw.created::timestamp)) at time zone
            'Europe/Moscow')::timestamp                                                                      as cw_date_tiket_open
         , (to_timestamp(EXTRACT(EPOCH FROM cw.created::timestamp)) at time zone
            'Europe/Moscow')::date                                                                           as created_CW
         , cw.deal
         , SUBSTRING(cw.deal, 'Y*([0-9]{1,100})') ::integer                                                  as deal_id
    from snb_b2b.voytekh_corpwelcome cw
    where (to_timestamp(EXTRACT(EPOCH FROM created::timestamp)) at time zone 'Europe/Moscow')::date >= '2021-12-01'
)
, fin as (
    select coalesce(calday.calday, cw.created_cw)  as calday
         , di.deal_id
         , di.status_lost
         , di.status
         , di.lost_reason
         , di.contract_id
         , di.contract_offerta_flg
         , di.manager_group
         , di.manager_login
         , di.manager_name
         , di.channel
         , di.tags
         , di.potential
         , di.corp_client_id
         , di.open_deal_time
         , di.open_deal_date
         , di.phinics_flg
         , di.restart_deal
         , case when di.deal_id is not null and (cw.deal_id is null or cw.fixed_flg = true or di.restart_deal = true)
             then true else false end as deal_flg
         , cw.cw_ticket_key
         , cw.type as cw_type
         , cw.status as cw_status
         , cw.resolution as cw_resolution
         , cw.fixed_flg as cw_fixed_flg
         , cw.cw_date_tiket_open
         , cw.created_CW as cw_created
         , cw.deal as cw_deal
         , cw.deal_id as cw_deal_id
    from calday
             left join t_deal di on di.open_deal_date = calday.calday
             full join cw on cw.created_cw = calday.calday and di.deal_id = cw.deal_id
    -- where di.deal_id in (114558)
           --(124573,116234,110642,110835,127672,122697,120297,119177)
)
, tt as (
    select coalesce(di.calday, (to_timestamp(coalesce(ld.tm_work_dttm, ld.tm_created_dttm)) at time zone 'Europe/Moscow')::date) as calday
         , di.deal_id
         , di.status_lost
         , di.status
         , di.lost_reason
         , di.contract_id
         , di.contract_offerta_flg
         , di.manager_group
         , di.manager_login
         , di.manager_name
         , di.channel
         , di.tags
         , di.potential
         , di.corp_client_id
         , di.open_deal_time
         , di.open_deal_date
         , di.phinics_flg
         , di.restart_deal
         , di.deal_flg
         , di.cw_ticket_key
         , di.cw_type
         , di.cw_status
         , di.cw_resolution
         , di.cw_fixed_flg
         , di.cw_date_tiket_open
         , di.cw_created
         , di.cw_deal
         , ld.tm_ticket_key                                                     as tm_ticket_key
         , (to_timestamp(coalesce(ld.tm_work_dttm, ld.tm_created_dttm)) at time zone 'Europe/Moscow')::date
                                                                                   tm_date_tiket_start
         , ld.appeal_flg                                                        as tm_appeal_flg
         , to_timestamp(ld.tm_open_dttm) at time zone 'Europe/Moscow'              tm_date_tiket_open
         , to_timestamp(ld.tm_work_dttm) at time zone 'Europe/Moscow'              tm_date_tiket_work
         , to_timestamp(ld.tm_lead_confirmed_dttm) at time zone 'Europe/Moscow' as tm_lead_confirmed_dttm
         , ld.tm_open_flg                                                       as tm_open_flg
         , ld.tm_work_flg                                                       as tm_work_flg
         , ld.lead_confirmed_flg                                                as tm_lead_confirmed_flg
    from fin di
             full join snb_b2b.alextitov_logdata994_ticket_crt ld on ld.cw_ticket_key = di.cw_ticket_key
        and (to_timestamp(coalesce(ld.tm_work_dttm, ld.tm_created_dttm)) at time zone 'Europe/Moscow')::date >= '2021-12-01'
)
, tt1 as (
    select tt.calday
         , tt.deal_id
         , tt.status_lost
         , tt.status
         , tt.lost_reason
         , tt.contract_id
         , tt.contract_offerta_flg
         , tt.manager_group
         , tt.manager_login
         , tt.manager_name
         , tt.channel
         , tt.tags
         , tt.potential
         , tt.corp_client_id
         , tt.open_deal_time
         , tt.open_deal_date
         , tt.phinics_flg
         , tt.restart_deal
         , tt.deal_flg
         , tt.cw_ticket_key
         , tt.cw_type
         , tt.cw_status
         , tt.cw_resolution
         , tt.cw_fixed_flg
         , tt.cw_date_tiket_open
         , tt.cw_created
         , tt.cw_deal
         , tt.tm_ticket_key
         , tt.tm_date_tiket_start
         , tt.tm_appeal_flg
         , tt.tm_date_tiket_open
         , tt.tm_date_tiket_work
         , tt.tm_lead_confirmed_dttm
         , tt.tm_open_flg
         , tt.tm_work_flg
         , tt.tm_lead_confirmed_flg
         , sum(fct_cntr.delivery_point_cnt)                     delivery_cnt
         , sum(sum(fct_cntr.delivery_point_cnt)) over(partition by tt.deal_id, tt.contract_id, tt.corp_client_id ) as  delivery_cnt_all
--          , sum(case
--                    when fct_cntr.utc_order_created_dttm between date_trunc('month', date_trunc('month', current_date - 1)::date - 1) and date_trunc('month', current_date - 1)::date - 1
--                        then fct_cntr.delivery_point_cnt end) as cnt_del_mon_l1
    from tt
             left join
        (select corp_contract_id, sum(delivery_point_cnt)  delivery_point_cnt from taxi_cdm_marketplace.fct_order
            where utc_order_created_dttm >= '2021-12-01'
            group by corp_contract_id
            ) as fct_cntr  on tt.contract_id = fct_cntr.corp_contract_id

    group by tt.calday
           , tt.deal_id
           , tt.status_lost
           , tt.status
           , tt.lost_reason
           , tt.contract_id
           , tt.contract_offerta_flg
           , tt.manager_group
           , tt.manager_login
           , tt.manager_name
           , tt.channel
           , tt.tags
           , tt.potential
           , tt.corp_client_id
           , tt.open_deal_time
           , tt.open_deal_date
           , tt.phinics_flg
           , tt.restart_deal
           , tt.deal_flg
           , tt.cw_ticket_key
           , tt.cw_type
           , tt.cw_status
           , tt.cw_resolution
           , tt.cw_fixed_flg
           , tt.cw_date_tiket_open
           , tt.cw_created
           , tt.cw_deal
           , tt.tm_ticket_key
           , tt.tm_date_tiket_start
           , tt.tm_appeal_flg
           , tt.tm_date_tiket_open
           , tt.tm_date_tiket_work
           , tt.tm_lead_confirmed_dttm
           , tt.tm_open_flg
           , tt.tm_work_flg
           , tt.tm_lead_confirmed_flg
)
, tt2 as (
    select tt.calday
         , tt.deal_id
         , tt.status_lost
         , tt.status
         , tt.lost_reason
         , tt.contract_id
         , tt.contract_offerta_flg
         , tt.manager_group
         , tt.manager_login
         , tt.manager_name
         , tt.channel
         , tt.tags
         , tt.potential
         , tt.corp_client_id
         , tt.open_deal_time
         , tt.open_deal_date
         , tt.phinics_flg
         , tt.restart_deal
         , tt.deal_flg
         , tt.cw_ticket_key
         , tt.cw_type
         , tt.cw_status
         , tt.cw_resolution
         , tt.cw_fixed_flg
         , tt.cw_date_tiket_open
         , tt.cw_created
         , tt.cw_deal
         , tt.tm_ticket_key
         , tt.tm_date_tiket_start
         , tt.tm_appeal_flg
         , tt.tm_date_tiket_open
         , tt.tm_date_tiket_work
         , tt.tm_lead_confirmed_dttm
         , tt.tm_open_flg
         , tt.tm_work_flg
         , tt.tm_lead_confirmed_flg
         , coalesce(tt.delivery_cnt, sum(fct_cntr.delivery_point_cnt))                                              delivery_cnt
         , coalesce(tt.delivery_cnt_all, sum(sum(fct_cntr.delivery_point_cnt))
                                         over (partition by tt.deal_id, tt.contract_id, tt.corp_client_id ))     as delivery_cnt_all
         , coalesce(tt.delivery_cnt_all, sum(sum(fct_cntr.delivery_point_cnt))
                                         over (partition by tt.deal_id, tt.contract_id, tt.corp_client_id )) >
           0                                                                                                     as del_flg

    from tt1 tt
left join
        (select corp_client_id, sum(delivery_point_cnt)  delivery_point_cnt from taxi_cdm_marketplace.fct_order
            where utc_order_created_dttm >= '2021-12-01'
            group by corp_client_id
        ) as fct_cntr on tt.contract_id is null and tt.phinics_flg = true
        and tt.corp_client_id = fct_cntr.corp_client_id
    group by tt.calday
           , tt.deal_id
           , tt.status_lost
           , tt.status
           , tt.lost_reason
           , tt.contract_id
           , tt.contract_offerta_flg
           , tt.manager_group
           , tt.manager_login
           , tt.manager_name
           , tt.channel
           , tt.tags
           , tt.potential
           , tt.corp_client_id
           , tt.open_deal_time
           , tt.open_deal_date
           , tt.phinics_flg
           , tt.restart_deal
           , tt.deal_flg
           , tt.cw_ticket_key
           , tt.cw_type
           , tt.cw_status
           , tt.cw_resolution
           , tt.cw_fixed_flg
           , tt.cw_date_tiket_open
           , tt.cw_created
           , tt.cw_deal
           , tt.tm_ticket_key
           , tt.tm_date_tiket_start
           , tt.tm_appeal_flg
           , tt.tm_date_tiket_open
           , tt.tm_date_tiket_work
           , tt.tm_lead_confirmed_dttm
           , tt.tm_open_flg
           , tt.tm_work_flg
           , tt.tm_lead_confirmed_flg
           , tt.delivery_cnt
           , tt.delivery_cnt_all
)

select tt2.*
        , case when status_lost=true then 'Проигранно'
                  when del_flg=true then 'Есть доставки'
                  when contract_id is not null then 'Заключен контракт'
                  when deal_id is not null then 'Переговоры' end as status_deal
, coalesce((tm_ticket_key is not null)::int,0) as  tm_flg
, coalesce((cw_ticket_key is not null)::int,0)  as  cw_flg
, coalesce(deal_flg::int,0)  as  deal_flg2
, substr(tm_date_tiket_start::varchar,1,7) as tm_date_month
, substr(cw_created::varchar,1,7) as cw_date_month
, substr(open_deal_date::varchar,1,7) as deal_date_month
, to_char(open_deal_date,'IYYYIW') deal_date_week
, ''::text as hierarchy
from tt2
;
